<?php
/**
 * Plugin Name: Cobran&ccedil;a Mycontas - WooCommerce
 * Plugin URI: http://www.mycontas.com.br/
 * Description: O Mycontas disponibiliza a integra&ccedil;&atilde;o da cobran&ccedil;a com o WooCommerce.
 * Author: Mycontas
 * Author URI: http://www.mycontas.com.br/guia_de_integracao.php/
 * Version: 1.0.1
 * License: Mycontas
 */

add_action( 'plugins_loaded', 'init_mycontas_gateway_class' );


function init_mycontas_gateway_class(){
	
	add_filter( 'woocommerce_payment_gateways', 'add_mycontas_gateway_class' , 1, 10);
	
	function add_mycontas_gateway_class( $methods ) {
		$methods[] = 'WC_Gateway_Mycontas';
		
		return $methods;
	}
	
	class WC_Gateway_Mycontas extends WC_Payment_Gateway {

		public function __construct() {
			global $woocommerce;
			
			$this->id					= 'mycontas';
			$this->icon					= plugins_url( 'imagem/LogoMycontasSite.png', __FILE__ );
			$this->has_fields			= false;
			$this->method_title			= __( 'Mycontas', 'woocommerce' );
			$this->method_description	= __( 'Mycontas - Meios de Pagamento', 'woocommerce' );
			$this->url      			= 'http://www.mycontas.com.br/servicosweb/wooCommerce/';
			
			//Load the settings.
			$this->init_form_fields();
			$this->init_settings();
			
			// Define user set variables
			$this->title       = $this->get_option( 'title' );
			$this->description = $this->get_option( 'description' );
			
			// Define user set variables
			$this->conta								= $this->get_option( 'conta' );
			$this->senha_token					= $this->get_option( 'senha_token' );
			$this->email_mycontas				= $this->get_option( 'email_mycontas' );
			$this->taxa									= $this->get_option( 'taxa' );
			$this->tipo_taxa							= $this->get_option( 'tipo_taxa' );
			$this->desconto							= $this->get_option( 'desconto' );
			$this->tipo_desconto					= $this->get_option( 'tipo_desconto' );
			$this->permitir_parcelamento	= $this->get_option( 'permitir_parcelamento' );
			$this->tipo_cobranca					= $this->get_option( 'tipo_cobranca' );
			$this->prazo_vencimento			= $this->get_option( 'prazo_vencimento' );
			$this->envio								= $this->get_option( 'envio' );
			$this->plano_de_contas				= $this->get_option( 'plano_de_contas' );
			$this->demonstrativo_1				= $this->get_option( 'demonstrativo_1' );
			
			// Actions
			add_action( 'woocommerce_update_options_payment_gateways_' . $this->id, array( $this, 'process_admin_options' ) );
			add_action( 'woocommerce_thankyou_mycontas', array( $this, 'thankyou_page' ) );
		}
		public function admin_options() {

            echo '<h3>' . __( 'Cobran&ccedil;a Mycontas', 'woocommerce' ) . '</h3>';

            if ( ! $this->is_valid_for_use() ) {

                // Valid currency.
                echo '<div class="inline error"><p>'. __( 'Mude a moeda da loja para Reais (R$).', 'woocommerce' ) . '</p></div>';

            } else {

                // Generate the HTML For the settings form.
                echo '<table class="form-table">';
                $this->generate_settings_html();
                echo '</table>';
            }
        }
		function is_valid_for_use() {
			if ( ! in_array( get_woocommerce_currency(), array( 'BRL' ) ) ) return false;
			return true;
		}
		function init_form_fields(){
			$this->form_fields = array(
				'aviso' => array(
					'title' => __( '* Campos requeridos', 'woocommerce' ),
					'type' => 'hidden',
					'label' => __( 'campo_requerido', 'woocommerce' ),
					'default' => ''
				),
					'enabled' => array(
					'title' => __( 'Habilitar/Desabilitar', 'woocommerce' ),
					'type' => 'checkbox',
					'label' => __( 'Habilitar os meios de pagamento do Mycontas', 'woocommerce' ),
					'default' => 'yes'
				),
				'title' => array(
					'title' => __( 'T&iacute;tulo*', 'woocommerce' ),
					'type' => 'text',
					'description' => __( 'T&iacute;tulo do Checkout', 'woocommerce' ),
					'default' => __( 'Cobran&ccedil;a Mycontas', 'woocommerce' )
				),
				'conta' => array(
					'title' => __( 'Token de identifica&ccedil;&atilde;o do Mycontas*', 'woocommerce' ),
					'type' => 'text',
					'description' => __( 'Digite o token com 20 caracteres alfanum&eacute;ricos, que foi informado no momento da assinatura da Myconta.', 'woocommerce' ),
					'default' => ''
				),
				'senha_token' => array(
					'title' => __( 'Senha do token*', 'woocommerce' ),
					'type' => 'password',
					'description' => __( 'Digite a senha do token da cobran&ccedil;a.', 'woocommerce' ),
					'default' => ''
				),
				'email_mycontas' => array(
					'title' => __( 'E-mail da conta no Mycontas*', 'woocommerce' ),
					'type' => 'text',
					'description' => __( 'E-mail de administrador do Mycontas.', 'woocommerce' ),
					'default' => ''
				),
				'taxa' => array(
					'title' => __( 'Taxa de cobran&ccedil;a', 'woocommerce' ),
					'type' => 'text',
					'description' => __( '(formato 000)', 'woocommerce' ),
					'default' => ''
				),
				'tipo_taxa' => array(
					'title' => __( 'Tipo de taxa', 'woocommerce' ),
					'type' => 'text',
					'description' => __( '0 = R$ (Reais) e 1 = % (Porcentagem)', 'woocommerce' ),
					'default' => ''
				),
					'desconto' => array(
					'title' => __( 'Desconto para pagamento com boleto', 'woocommerce' ),
					'type' => 'text',
					'description' => __( 'Ofere&ccedil;a, ao seu cliente, desconto para pagamento com boleto. (formato 000).', 'woocommerce' ),
					'default' => '000'
				),
				'tipo_desconto' => array(
					'title' => __( 'Tipo do desconto', 'woocommerce' ),
					'type' => 'text',
					'description' => __( '0 = R$ (Reais) e 1 = % (Porcentagem)', 'woocommerce' ),
					'default' => '0'
				),
				'permitir_parcelamento' => array(
					'title' => __( 'Parcelamento no cart&atilde;o de cr&eacute;dito', 'woocommerce' ),
					'type' => 'text',
					'description' => __( 'Ofere&ccedil;a pagamento parcelado no cart&atilde;o de cr&eacute;dito.   0 ou 1 = venda a vista no cart&atilde;o ou 2 a 12 para parcelas iguais sem juros', 'woocommerce' ),
					'default' => '0'
				),
				'tipo_cobranca' => array(
					'title' => __( 'Meios de pagamento aceitos*', 'woocommerce' ),
					'type' => 'text',
					'description' => __( 'B - Boleto; C - Cart&atilde;o de cr&eacute;dito; D - Cart&atilde;o de d&eacute;bito; T - Transfer&ecirc;ncia On-line; X - pular tipo.<br />Ex.: BCDX (Aceitar Boleto, Cr&eacute;dito e D&eacute;bito)', 'woocommerce' ),
					'default' => ''
				),
				'prazo_vencimento' => array(
					'title' => __( 'Prazo para vencimento*', 'woocommerce' ),
					'type' => 'text',
					'description' => __( 'Prazo em dias para o vencimento. O vencimento ser&aacute; a data atual somada ao n&uacute;mero de dias do prazo de vencimento.', 'woocommerce' ),
					'default' => ''
				),
				'envio' => array(
					'title' => __( 'Forma de envio da cobran&ccedil;a*', 'woocommerce' ),
					'type' => 'text',
					'description' => __( 'Indica como deve ser feito envio da cobran&ccedil;a para o sacado: &quot; 1 &quot; significa apenas e-mail, &quot; 2 &quot; apenas impressa pelo correio, &quot; 3 &quot; das duas formas anteriores e &quot; 4 &quot; s&oacute; &eacute; feito o registro da cobran&ccedil;a (o default &eacute; &quot; 1 &quot;).', 'woocommerce' ),
					'default' => ''
				),
				'plano_de_contas' => array(
					'title' => __( 'C&oacute;digo do plano de contas*', 'woocommerce' ),
					'type' => 'text',
					'description' => __( 'Esta venda dever&aacute; ser lan&ccedil;ada com qual c&oacute;digo do seu plano de contas.<br />Em caso de d&uacute;vida pedir informa&ccedil;&otilde;es ao suporte Mycontas.', 'woocommerce' ),
					'default' => '0'
				),
				'demonstrativo_1' => array(
					'title' => __( 'Demonstrativo*', 'woocommerce' ),
					'type' => 'text',
					'description' => __( 'Primeira linha do demonstrativo da cobran&ccedil;a, tamb&eacute;m pode ser usado para preencher o assunto do e-mail de cobran&ccedil;a' ),
					'default' => ''
				)
			);
		}
		function process_payment( $order_id ) {
			global $woocommerce;
			$order = new WC_Order( $order_id );
			
			$mycontas_args = $this->get_mycontas_args( $order );
			
			$mycontas_args = http_build_query( $mycontas_args, '', '&' );
			
			$mycontas_url = $this->url;

			// Mark as on-hold (we're awaiting the cheque)
			$order->update_status('on-hold', __( 'Aguardando pagamento (Mycontas)', 'woocommerce' ));

			// Reduce stock levels
			$order->reduce_order_stock();

			// Remove cart
			$woocommerce->cart->empty_cart();
			
			$mycontas_link_completo = $mycontas_url . $mycontas_args;
			
			

			// Return thankyou redirect
			return array(
				'result' => 'success',
				'redirect' => $this->get_return_url( $order ) //$mycontas_url . $mycontas_args
			);
		}
		function receipt_page( $order ) {

			echo '<p>'.__( 'Obrigado pelo pedido, por favor clique no bot&atilde;o abaixo para pagar com cart&otilde;es ou boleto no Mycontas.<br /> Ao clicar, voc&ecirc; ser&aacute; redirecionado para o site de intermedia&ccedil;&atilde;o de pagamentos Mycontas.', 'woocommerce' ).'</p>';

			echo $this->generate_mycontas_form( $order );

		}

		public function thankyou_page( $order_id ) {
 
			$this->receipt_page( $order_id );

		}
		function get_mycontas_args( $order ) {
			global $woocommerce;
			
			$order_id = $order->id;
			$cliente_cep = str_replace("-","",$order->billing_postcode); 
			
			$mycontas_args = array(
				'conta'								=> $this->conta,
				'senha_token'					=> $this->senha_token,
				'email_mycontas'			=> $this->email_mycontas,
				'taxa'								=> $this->taxa,
				'tipo_taxa'						=> $this->tipo_taxa,
				'desconto'						=> $this->desconto,
				'tipo_desconto'				=> $this->tipo_desconto,
				'permitir_parcelamento'	=> $this->permitir_parcelamento,
				'tipo_cobranca'				=> $this->tipo_cobranca,
				'prazo_vencimento'		 	=> $this->prazo_vencimento,
				'envio' 								=> $this->envio,
				'cobranca_desc1'				=> $this->demonstrativo_1,
				'plano_de_contas'			=> $this->plano_de_contas,
				'cobranca_desc2'				=> 'Pedido #: ' . $order->id,
				'cobranca_codigo'			=> $order->id,
				// Cliente
				'cliente_nome'					=> $order->billing_first_name . ' ' . $order->billing_last_name,
				'cliente_email'					=> $order->billing_email,
				'cliente_endereco'			=> $order->billing_address_1,
				'cliente_complemento'	=> $order->billing_address_2,
				'cliente_cidade'				=> $order->billing_city,
				'cliente_estado'				=> $order->billing_state,
				'cliente_cep'					=> $cliente_cep,
				'cliente_telefone1'			=> $order->billing_phone,
				'cliente_ip'						=> $_SERVER ["REMOTE_ADDR"],
				'tipo_ws'				=> 'woocommerce',
				'valor'				=> number_format( $order->get_total(), 2, '', '' )
				
			);
			
			$mycontas_args = apply_filters( 'woocommerce_mycontas_args', $mycontas_args );

			return $mycontas_args;
		}
		function generate_mycontas_form( $order_id ) {
			global $woocommerce;
			
			$order = new WC_Order( $order_id );
			
			$mycontas_url = $this->url;
			
			$mycontas_args = $this->get_mycontas_args( $order );

			$mycontas_args_array = array();
			
			foreach ($mycontas_args as $key => $value) {
				$mycontas_args_array[] = '<input type="text" name="'.esc_attr( $key ).'" value="'.esc_attr( $value ).'" />';
			}
			

			
			return '<form action="'.esc_url( $mycontas_url ).'" method="post" id="mycontas_payment_form" target="_blank">
					' . implode( '', $mycontas_args_array) . '
					<input type="submit" class="button alt" id="submit_mycontas_payment_form" value="' . __( 'Pagamento via Mycontas', 'woocommerce' ) . '" /> <a class="button cancel" href="'.esc_url( $order->get_cancel_order_url() ).'">'.__( 'Cancel pedido', 'woocommerce' ).'</a>
					</form>';
		}
	}

	/*class WC_Mycontas extends WC_Gateway_Mycontas {
		public function __construct() {
			_deprecated_function( 'WC_Mycontas', '1.4', 'WC_Gateway_Mycontas' );
			parent::__construct();
		}
	}
	*/
}
?>
