<?php

function mycontasdedito_config() {
    $configarray = array(
     "FriendlyName" => array("Type" => "System", "Value"=>"Mycontas - Cartão de Débito"),
     "taxa" => array("FriendlyName" => "Taxa de Cobrança", "Type" => "text", "Size" => "10", "Description" => "(formato 0,00)"),
     "tipo_taxa" => array("FriendlyName" => "Tipo de Taxa", "Type" => "dropdown", "Options" => "R$,%", "Description" => "R$ = Reais e % = Porcentagem"),
     "multa" => array("FriendlyName" => "Multa de Cobrança", "Type" => "text", "Size" => "10", "Description" => "(formato 0,00)"),
     "tipo_multa" => array("FriendlyName" => "Tipo de Multa", "Type" => "dropdown", "Options" => "R$,%", "Description" => "R$ = Reais e % = Porcentagem"),
     "desconto" => array("FriendlyName" => "Desconto de Cobrança", "Type" => "text", "Size" => "10", "Description" => "(formato 0,00)"),
     "tipo_desconto" => array("FriendlyName" => "Tipo de desconto", "Type" => "dropdown", "Options" => "R$,%", "Description" => "R$ = Reais e % = Porcentagem"),
     "desconto_ate_dia" => array("FriendlyName" => "Desconto até", "Type" => "text", "Size" => "2", "Description" => "(formato 0)"),
     "tipo_cobranca" => array("FriendlyName" => "Meios de Pagto Aceitos", "Type" => "text", "Size" => "10", "Description" => "B - Boleto; C - Cartão de crédito; D - Cartão de débito; T - Transferência On-line. <br>Ex.: BCD (Aceitar Boleto, Crédito e Débito)<br>"),
     "plano_de_contas" => array("FriendlyName" => "Plano de contas", "Type" => "text", "Size" => "10", "Description" => "Digite o plano de contas"),
     "prazo_vencimento" => array("FriendlyName" => "Prazo de Vencimento", "Type" => "text", "Size" => "2", "Description" => "Após o vcto da fatura, o vcto da cobrança será calculado através do vcto da fatura + o prazo de vencimento."),
     "envio" => array("FriendlyName" => "Tipo de envio", "Type" => "text", "Size" => "1", "Description" => "Preencha como deseja o envio da Cobrança Mycontas. e - Email; p - Correios; b - Ambos; n - Nenhum (Padrão)"),
//     "encoding" => array("FriendlyName" => "Encoding do WHMCS", "Type" => "text", "Size" => "10", "Description" => "Digite o encoding do seu WHMCS. EX: UTF-8. Não obrigatório."),
    );
	return $configarray;
}

function mycontasdebito_link($params) {

include 'callback/ConfigMycontas.php';
$vencimento = '';
$str_error = '';
$user_id = '';

$command = "getinvoice";
$adminuser = $login_whmcs;
$values["invoiceid"] = $params['invoiceid'];

$data = localAPI($command,$values,$adminuser);

if (is_array($data)) {
	foreach($data as $key => $value) {
		if ($key == 'userid')
			$user_id = $data[$key];
		if ($key == 'duedate')
			$vencimento = $data[$key];

		if ($key == 'items') {
			$items = $data[$key];
			foreach($items as $keyItems => $value) {
				if ($keyItems == 'item') {
					$item = $items[$keyItems];
					$i = 0;
					foreach($item as $keyItem => $value) {
						$desc = $item[$keyItem];
						foreach($desc as $descItem => $value) {
							if ($descItem == 'description') {
								$var_desc = $desc[$descItem];
								if ($params['encoding'] == 'UTF-8')
									$description[$i] = utf8_decode($var_desc);
								else
									$description[$i] = $var_desc;
								$i = $i + 1;
							}
						}
					}
				}
			}
		}
	}
} else {
	$resultado = $data;
}

$nome_cliente = $params['clientdetails']['companyname'];
$firstname = $params['clientdetails']['firstname'];
$lastname = $params['clientdetails']['lastname'];
$email_cliente = $params['clientdetails']['email'];
$logradouro = $params['clientdetails']['address1'];
$bairro = $params['clientdetails']['address2'];
$cidade = $params['clientdetails']['city'];
$sigla_uf = f_uf_mycontasdebito($params['clientdetails']['state']);
$cli_cep = $params['clientdetails']['postcode'];

if (is_null($nome_cliente) || trim($nome_cliente) == '' || $nome_cliente == ' ') {
	$nome_cliente = $firstname . ' ' . $lastname;
}

$data_atual = date('Y-m-d', time());

if ($vencimento == '') {
	$vencimento = date('Y-m-d', time()+$params['prazo_vencimento']*24*60*60);
}

// Obtendo a diferença em dias entre a data de vencimento e a data atual
$ano_venc = substr($vencimento,0,4);
$mes_venc = substr($vencimento,5,2);
$dia_venc = substr($vencimento,8,2);
$venc = $dia_venc."-".$mes_venc."-".$ano_venc;

$ano_atual = substr($data_atual,0,4);
$mes_atual = substr($data_atual,5,2);
$dia_atual = substr($data_atual,8,2);
$data_atual = $dia_atual."-".$mes_atual."-".$ano_atual;

$venc = mktime(0,0,0,$mes_venc,$dia_venc,$ano_venc);
$data_atual = mktime(0,0,0,$mes_atual,$dia_atual,$ano_atual);

$dias = ($data_atual - $venc)/86400;
$dias = ceil($dias);

if ($dias > 0) { // Fatura vencida
   if ($params['prazo_vencimento'] != '') {
      $vencimento = date('Y-m-d',strtotime($vencimento)+$params['prazo_vencimento']*24*60*60);
   } else {
      $vencimento = date('Y-m-d',strtotime($vencimento)+5*24*60*60);
   }
} else {
  $vencimento = date('Y-m-d',strtotime($vencimento));
}

$parametros = "@t@conta@v@".$conta_mycontas;
$parametros .= "@t@senha@v@".$senha_mycontas;
$parametros .= "@t@valor@v@".$params['amount'];
$parametros .= "@t@taxa@v@".$params['taxa'];
$parametros .= "@t@tipo_taxa@v@".$params['tipo_taxa'];
$parametros .= "@t@desconto@v@".$params['desconto'];
$parametros .= "@t@tipo_desconto@v@".$params['tipo_desconto'];
$parametros .= "@t@desconto_ate_dia@v@".$params['desconto_ate_dia'];
$parametros .= "@t@receber_ate_dia@v@".$params['receber_ate_dia'];
$parametros .= "@t@multa@v@".$params['multa'];
$parametros .= "@t@tipo_multa@v@".$params['tipo_multa'];
$parametros .= "@t@num_document@v@".$params['invoiceid'];
$parametros .= "@t@encoding@v@".$params['encoding'];
$parametros .= "@t@plano_de_contas@v@".$params['plano_de_contas'];
$parametros .= "@t@tipo_ws@v@WHMCS";
$parametros .= "@t@tipo_cobranca@v@XXDX";
$parametros .= "@t@envio@v@".$params['envio'];
$parametros .= "@t@demonstrativo_1@v@".$params['description'];
$parametros .= "@t@demonstrativo_2@v@".$description[0];
$parametros .= "@t@demonstrativo_3@v@".$description[1];
$parametros .= "@t@demonstrativo_4@v@".$description[2];
$parametros .= "@t@demonstrativo_5@v@".$description[3];
$parametros .= "@t@demonstrativo_6@v@".$description[4];
$parametros .= "@t@demonstrativo_7@v@".$description[5];
$parametros .= "@t@demonstrativo_8@v@".$description[6];
$parametros .= "@t@demonstrativo_9@v@".$description[7];
$parametros .= "@t@demonstrativo_10@v@".$description[8];
$parametros .= "@t@vencimento@v@".$vencimento;
$parametros .= "@t@nome@v@".$nome_cliente;
$parametros .= "@t@email_1@v@".$email_cliente;
$parametros .= "@t@endereco_logradouro@v@".$logradouro;
$parametros .= "@t@endereco_numero@v@0";
$parametros .= "@t@endereco_bairro@v@".$bairro;
$parametros .= "@t@endereco_cidade@v@".$cidade;
$parametros .= "@t@endereco_estado@v@".$sigla_uf;
$parametros .= "@t@endereco_cep@v@".$cli_cep;

$parametros_cripto = base64_encode($parametros);

$code='
<form action="http://www.mycontas.com.br/BillingWeb/" method="post" target="_BLANK">

<input type="hidden" name="cripto" value="S">
<input type="hidden" name="dados_cripto" value="'.$parametros_cripto.'">
<input type="hidden" name="ip" value="'.$_SERVER['REMOTE_ADDR'].'">

<input type="hidden" name="str_error" value="'.$str_error.'">';

$code.='<input type="submit" value="'.$params['langpaynow'].'"></form>';

return $code;

}

function f_uf_mycontasdebito($estado) {
	$estado = strtoupper($estado);
	$acentos = array(
		'A' => array("Á", "À", "Â", "Ã", "Ä", "á", "à", "â", "ã", "ä", ),
		'E' => array("É", "È", "Ê", "Ë", "é", "è", "ê", "ë", ),
		'I' => array("Í", "Ì", "Î", "Ï", "í", "ì", "î", "ï", ),
		'O' => array("Ó", "Ò", "Ô", "Õ", "Ö", "ó", "ò", "ô", "õ", "ö", ),
		'U' => array("Ú", "Ù", "Û", "Ü", "ú", "ù", "û", "ü", ),
		'misc' => array(" ", ".", ",", ":", ";", "<", ">", "\\", "/",
		"\"", "'", "|", "?", "!", "@", "#", "$", "%", "&", "*", "(",
		")", "[", "]", "{", "}", "´", "`", "~", "^", "¨", "-", "_",
		"=", "+", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ),
	);
	$estado = str_ireplace($acentos['A'], "A", $estado);
	$estado = str_ireplace($acentos['E'], "E", $estado);
	$estado = str_ireplace($acentos['I'], "I", $estado);
	$estado = str_ireplace($acentos['O'], "O", $estado);
	$estado = str_ireplace($acentos['U'], "U", $estado);
	$estado = str_ireplace($acentos['misc'], "", $estado);
	switch ($estado) {
		case "ACRE": $estado = "AC"; break;
		case "ALAGOAS": $estado = "AL"; break;
		case "AMAPA": $estado = "AP"; break;
		case "AMAZONAS": $estado = "AM"; break;
		case "BAHIA": $estado = "BA"; break;
		case "CEARA": $estado = "CE"; break;
		case "DISTRITOFEDERAL": $estado = "DF"; break;
		case "ESPIRITOSANTO": $estado = "ES"; break;
		case "GOIAS": $estado = "GO"; break;
		case "MARANHAO": $estado = "MA"; break;
		case "MATOGROSSO": $estado = "MT"; break;
		case "MATOGROSSODOSUL": $estado = "MS"; break;
		case "MINASGERAIS": $estado = "MG"; break;
		case "PARA": $estado = "PA"; break;
		case "PARAIBA": $estado = "PB"; break;
		case "PARANA": $estado = "PR"; break;
		case "PERNAMBUCO": $estado = "PE"; break;
		case "PIAUI": $estado = "PI"; break;
		case "RIODEJANEIRO": $estado = "RJ"; break;
		case "RIOGRANDEDONORTE": $estado = "RN"; break;
		case "RIOGRANDEDOSUL": $estado = "RS"; break;
		case "RONDONIA": $estado = "RO"; break;
		case "RORAIMA": $estado = "RR"; break;
		case "SANTACATARINA": $estado = "SC"; break;
		case "SAOPAULO": $estado = "SP"; break;
		case "SERGIPE": $estado = "SE"; break;
		case "TOCANTINS": $estado = "TO"; break;
	}
	return $estado;
}
?>
